import numpy as np
import scipy as sp
import scipy.optimize as opt
import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt
import pylab
import os, time
import multiprocessing
import scipy.sparse.linalg as sparselin
import cmath
import matplotlib.tri as tri
import matplotlib.mlab as griddata
import matplotlib.colors as mcolors
import scipy.linalg as linalg
import argparse
import matplotlib.mlab as griddata
import matplotlib.transforms as mtransforms
import matplotlib.gridspec as gridspec
from   matplotlib import rc
from   matplotlib.animation import FFMpegWriter
from   mpl_toolkits.axes_grid1 import make_axes_locatable
from   pylab import *
from   scipy.signal import savgol_filter
from   scipy.interpolate import make_interp_spline
from   matplotlib import image as mpimg
from   mpl_toolkits.axes_grid1 import make_axes_locatable
from   PIL import Image
import os.path
#----------------------------- rc Parameters-----------------------------------
w= 3.375; h = 1.35; fs = 14; lw = 1.5; ax_lw = 0.5; tick_M = 1.5; tick_m = 0.8;
tex = 1; minor_x = 0; minor_y = 0; np_h=4; np_v=3; minor = 0; mks = 1;
mew=0.1; FontFamily="Times New Roman";
if minor: 
    minor_x = 1
    minor_y = 1
#------------------------------------------------------------------------------
# Tex
plt.rcParams['text.usetex'] = False
rcParams.update({'font.family': FontFamily})
# Fig
rcParams.update({'figure.figsize': [w*np_h,h*np_v]})
rcParams.update({'figure.dpi': 150}) 
rcParams.update({'legend.fontsize': fs})
# Axes
rcParams.update({'axes.labelsize' : fs})
rcParams.update({'axes.linewidth':  ax_lw})
# Ticks
rcParams.update({'xtick.labelsize': fs-2})
rcParams.update({'ytick.labelsize': fs-2}) 
rcParams.update({'xtick.direction': 'in'}) 
rcParams.update({'ytick.direction': 'in'}) 
rcParams.update({'xtick.major.width': ax_lw}) 
rcParams.update({'ytick.major.width': ax_lw}) 
rcParams.update({'xtick.major.pad': 3})
rcParams.update({'ytick.major.pad': 3})
rcParams.update({'xtick.major.size': tick_M})
rcParams.update({'ytick.major.size': tick_M})  
rcParams.update({'xtick.top': False}) 
rcParams.update({'xtick.labeltop': False}) 
rcParams.update({'xtick.bottom': True})  
rcParams.update({'xtick.labelbottom': True})
if minor_x:
    rcParams.update({'xtick.minor.visible':True})
    rcParams.update({'xtick.minor.size': tick_m}) 
    rcParams.update({'xtick.minor.width': ax_lw}) 
if minor_y:
    rcParams.update({'ytick.minor.visible':True})  
    rcParams.update({'ytick.minor.size': tick_m}) 
    rcParams.update({'ytick.minor.width': ax_lw}) 
# Lines
rcParams.update({'lines.markersize': mks})
rcParams.update({'lines.linewidth': lw})
rcParams.update({'lines.markeredgewidth': mew})
#------------------------------------------------------------------------------

#------------------------------- Plot Function---------------------------------
def PlotFun(ax, X, Y, NP, PCol, PLab, PLSty, XLab, YLab, Tit, TitFS, SetZ, SetminY, FSize, Legloc, LegFS):
    if NP>1:
        for iY in range(NP):
            ax.plot(X, Y[:,iY], label = PLab[iY], linestyle = PLSty, color = PCol[iY])    
    else:
        ax.plot(X, Y, label = PLab, linestyle = PLSty, color = PCol) 
    ax.set_title(Tit, fontsize=TitFS)
    ax.set_xlabel(XLab, fontsize=FSize)
    ax.set_ylabel(YLab, fontsize=FSize, labelpad=2)
    ax.set_xlim(min(X),max(X))
    if SetminY:
        ax.set_ylim(bottom=0.0, top=max(Y[:])*1.1)
    if len(PLab)!=0 and PLab[0]!='':
        ax.legend(loc=Legloc, framealpha=0.0, fontsize=LegFS)
    if SetZ:
        ax.axhline(0.0, lw=0.01, color='k')
#------------------------------------------------------------------------------
#------------------------------- Variables ------------------------------------
Orbitals  = ['s',  '$p_x$', '$p_y$', '$p_z$', '$d_{z^2}$', '$d_{x^2-y^2}$', '$d_{xy}$', '$d_{xz}$', '$d_{yz}$', '$f_{z^3}$', '$f_{xz^2}$', '$f_{yz^2}$', '$f_{zx^2}$', '$f_{xyz}$', '$f_{x^3-3xy^2}$', '$f_{3yx^2-y^3}$']
Orbital   = ['s1', 'p1', 'p2', 'p3', 'd1', 'd2', 'd3', 'd4', 'd5', 'f1', 'f2', 'f3', 'f4', 'f5', 'f6', 'f7']
#------------------------------------------------------------------------------

for F in os.listdir():
    if F.endswith(".in"):
        fname = F
f = open(fname,'r')
while True:
    line = f.readline()
    if "System.Name" in line:
        SysNam = str(line.split()[1])
    if "scf.SpinPolarization" in line:
        if str(line.split()[1]).lower()=='off':
            SP = 1
        else:
            SP = 2
        break
f.close()
EnL = -6
EnU = 8
        
#-----------------------------  Figure ----------------------------------------   
fig = plt.figure(figsize=(30,10),constrained_layout=False)
gs  = gridspec.GridSpec(nrows=2, ncols=5, figure=fig, left=0.17, bottom=0.1, right=0.95, top=0.95, wspace=0.2, hspace=0.2)
ax1 = fig.add_subplot(gs[0,0]); ax2 = fig.add_subplot(gs[0,1]); ax3 = fig.add_subplot(gs[0,2]); ax4 = fig.add_subplot(gs[0,3]); ax5 = fig.add_subplot(gs[0,4]); 
ax6 = fig.add_subplot(gs[1,0]); ax7 = fig.add_subplot(gs[1,1]); ax8 = fig.add_subplot(gs[1,2]); ax9 = fig.add_subplot(gs[1,3]); ax10 = fig.add_subplot(gs[1,4]); 


path = SysNam+'.DOS.Tetrahedron'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax1, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax1, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='Total', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax1, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='Total', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    ax1.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax1.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax1.set_ylabel('DOS')
    ax1.set_xlabel('Energy (eV)')
    ax1.set_xlim(EnL,EnU)


path = SysNam+'.PDOS.Tetrahedron.atom1.s1'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax2, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax2, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[0], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax2, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[0], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)   
    ax2.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax2.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax2.set_ylabel('DOS')
    ax2.set_xlabel('Energy (eV)')
    ax2.set_xlim(EnL,EnU)


path = SysNam+'.PDOS.Tetrahedron.atom1.p1'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax3, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax3, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[1], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax3, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[1], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)    
    ax3.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax3.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax3.set_ylabel('DOS')
    ax3.set_xlabel('Energy (eV)')
    ax3.set_xlim(EnL,EnU)


path = SysNam+'.PDOS.Tetrahedron.atom1.p2'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax4, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax4, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[2], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax4, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[2], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)   
    ax4.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax4.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax4.set_ylabel('DOS')
    ax4.set_xlabel('Energy (eV)')
    ax4.set_xlim(EnL,EnU)


path = SysNam+'.PDOS.Tetrahedron.atom1.p3'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax5, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax5, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[3], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax5, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[3], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)    
    ax5.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax5.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax5.set_ylabel('DOS')
    ax5.set_xlabel('Energy (eV)')
    ax5.set_xlim(EnL,EnU)


path = SysNam+'.PDOS.Tetrahedron.atom1.d1'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax6, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax6, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[4], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax6, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[4], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    ax6.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax6.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax6.set_ylabel('DOS')
    ax6.set_xlabel('Energy (eV)')
    ax6.set_xlim(EnL,EnU)


path = SysNam+'.PDOS.Tetrahedron.atom1.d2'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax7, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax7, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[5], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax7, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[5], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    ax7.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax7.axhline(0.0, lw=0.5, color='k', linestyle=':') 
    ax7.set_ylabel('DOS')
    ax7.set_xlabel('Energy (eV)')
    ax7.set_xlim(EnL,EnU)


path = SysNam+'.PDOS.Tetrahedron.atom1.d3'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax8, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax8, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[6], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax8, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[6], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    ax8.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax8.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax8.set_ylabel('DOS')
    ax8.set_xlabel('Energy (eV)')
    ax8.set_xlim(EnL,EnU)


path = SysNam+'.PDOS.Tetrahedron.atom1.d4'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax9, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax9, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[7], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax9, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[7], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    ax9.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax9.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax9.set_ylabel('DOS')
    ax9.set_xlabel('Energy (eV)')
    ax9.set_xlim(EnL,EnU)


path = SysNam+'.PDOS.Tetrahedron.atom1.d5'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax10, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax10, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[8], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax10, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit=Orbitals[8], TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    ax10.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax10.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax10.set_ylabel('DOS')
    ax10.set_xlabel('Energy (eV)')
    ax10.set_xlim(EnL,EnU)
    
    
plt.savefig('DOS.png', bbox_inches='tight', dpi=200)



