import numpy as np
import scipy as sp
import scipy.optimize as opt
import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt
import pylab
import os, time
import multiprocessing
import scipy.sparse.linalg as sparselin
import cmath
import matplotlib.tri as tri
import matplotlib.mlab as griddata
import matplotlib.colors as mcolors
import scipy.linalg as linalg
import argparse
import matplotlib.mlab as griddata
import matplotlib.transforms as mtransforms
import matplotlib.gridspec as gridspec
from   matplotlib import rc
from   matplotlib.animation import FFMpegWriter
from   mpl_toolkits.axes_grid1 import make_axes_locatable
from   pylab import *
from   scipy.signal import savgol_filter
from   scipy.interpolate import make_interp_spline
from   matplotlib import image as mpimg
from   mpl_toolkits.axes_grid1 import make_axes_locatable
from   PIL import Image
import os.path
#----------------------------- rc Parameters-----------------------------------
w= 3.375; h = 1.35; fs = 14; lw = 1.5; ax_lw = 0.5; tick_M = 1.5; tick_m = 0.8;
tex = 1; minor_x = 0; minor_y = 0; np_h=4; np_v=3; minor = 0; mks = 6;
mew=0.1; FontFamily="Times New Roman";
if minor: 
    minor_x = 1
    minor_y = 1
#------------------------------------------------------------------------------
# Tex
plt.rcParams['text.usetex'] = False
rcParams.update({'font.family': FontFamily})
# Fig
rcParams.update({'figure.figsize': [w*np_h,h*np_v]})
rcParams.update({'figure.dpi': 150}) 
rcParams.update({'legend.fontsize': fs})
# Axes
rcParams.update({'axes.labelsize' : fs})
rcParams.update({'axes.linewidth':  ax_lw})
# Ticks
rcParams.update({'xtick.labelsize': fs-2})
rcParams.update({'ytick.labelsize': fs-2}) 
rcParams.update({'xtick.direction': 'in'}) 
rcParams.update({'ytick.direction': 'in'}) 
rcParams.update({'xtick.major.width': ax_lw}) 
rcParams.update({'ytick.major.width': ax_lw}) 
rcParams.update({'xtick.major.pad': 3})
rcParams.update({'ytick.major.pad': 3})
rcParams.update({'xtick.major.size': tick_M})
rcParams.update({'ytick.major.size': tick_M})  
rcParams.update({'xtick.top': False}) 
rcParams.update({'xtick.labeltop': False}) 
rcParams.update({'xtick.bottom': True})  
rcParams.update({'xtick.labelbottom': True})
if minor_x:
    rcParams.update({'xtick.minor.visible':True})
    rcParams.update({'xtick.minor.size': tick_m}) 
    rcParams.update({'xtick.minor.width': ax_lw}) 
if minor_y:
    rcParams.update({'ytick.minor.visible':True})  
    rcParams.update({'ytick.minor.size': tick_m}) 
    rcParams.update({'ytick.minor.width': ax_lw}) 
# Lines
rcParams.update({'lines.markersize': mks})
rcParams.update({'lines.linewidth': lw})
rcParams.update({'lines.markeredgewidth': mew})
#------------------------------------------------------------------------------

#------------------------------- Plot Function---------------------------------
def PlotFun(ax, X, Y, NP, PCol, PLab, PLSty, PMrK, XLab, YLab, Tit, TitFS, SetZ, SetminY, FSize, Legloc, LegFS):
    if NP>1:
        for iY in range(NP):
            ax.plot(X, Y[:,iY], label = PLab[iY], marker=PMrK, linestyle = PLSty, color = PCol[iY])    
    else:
        ax.plot(X, Y, label = PLab, linestyle = PLSty, marker=PMrK, color = PCol) 
    ax.set_title(Tit, fontsize=TitFS)
    ax.set_xlabel(XLab, fontsize=FSize)
    ax.set_ylabel(YLab, fontsize=FSize, labelpad=2)
    ax.set_xlim(min(X),max(X))
    if SetminY:
        ax.set_ylim(bottom=0.0, top=max(Y[:])*1.1)
    if len(PLab)!=0 and PLab[0]!='':
        ax.legend(loc=Legloc, framealpha=0.0, fontsize=LegFS)
    if SetZ:
        ax.axhline(0.0, lw=0.01, color='k')
#------------------------------------------------------------------------------



Vec = np.array([[-1.43300,  1.43300,   1.43300],
                [ 1.43300, -1.43300,   1.43300],
                [ 1.43300,  1.43300,  -1.43300]])

Ver = (np.pi*np.linalg.inv(Vec.transpose())).transpose()

Data = np.loadtxt("./Jx.log", skiprows=34, max_rows=124)
Jx = []
for ii in range(len(Data)):
    R = Data[ii,2]*Vec[0,:] + Data[ii,3]*Vec[1,:] + Data[ii,4]*Vec[2,:]
    Jx.append(np.array([np.sqrt(R[0]**2+R[1]**2+R[2]**2), Data[ii,5]]))
    
Jx  = np.array(Jx)
Ind = np.argsort( Jx[:,0] ); 
Jx  = Jx[Ind]

# fig=plt.figure(figsize=(8,6)); ax1 = fig.add_subplot(111)
# PlotFun(ax=ax1, X=Jx[:,0], Y=Jx[:,1], NP=1, PCol='b', PLab='', PLSty ='--', PMrK='o', XLab='R (Ang)', YLab='Jx (meV)', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)        
# ax1.axhline(0, lw=0.1, color='k')
# ax1.set_xlim(2,)        
# plt.tight_layout()
# plt.savefig('Jx.png', bbox_inches='tight', dpi=200)

KPP  = np.loadtxt("./Kpoints.out")
KP   = np.zeros((len(KPP),3),float);
for ii in range(len(KPP)):
    KP[ii,:] = KPP[ii,0]*Ver[0,:] + KPP[ii,1]*Ver[1,:] + KPP[ii,2]*Ver[2,:]

Kp   = np.zeros((len(KP)),float);
Omeg = np.zeros((len(KP)),float);
for ii in range(len(KP)):
    if ii>0:
        Kp[ii] = Kp[ii-1] + np.sqrt((KP[ii,0]-KP[ii-1,0])**2+(KP[ii,1]-KP[ii-1,1])**2+(KP[ii,2]-KP[ii-1,2])**2)    
    for jj in range(len(Jx)):
        Rij = Data[jj,2]*Vec[0,:] + Data[jj,3]*Vec[1,:] + Data[jj,4]*Vec[2,:]
        Omeg[ii] +=  np.real(2*Jx[jj,1]*(1-np.exp(1j*np.dot(KP[ii,:],Rij))))

fig=plt.figure(figsize=(8,6)); ax1 = fig.add_subplot(111)
PlotFun(ax=ax1, X=Kp, Y=Omeg, NP=1, PCol='b', PLab='', PLSty ='-', PMrK=None, XLab='', YLab='$\hbar \omega$ (meV)', Tit='', TitFS=fs, SetZ=0, SetminY=1, FSize=fs, Legloc='best', LegFS=fs)        
HSP = [Kp[0],Kp[99],Kp[198],Kp[297],Kp[396],Kp[495]]
for k in HSP:
    plt.axvline(k, lw=0.5, color='0.8')
plt.xticks(HSP,['G', 'H', 'N', 'G', 'P', 'H'])
plt.tight_layout()
plt.savefig('Magnon.png', bbox_inches='tight', dpi=200)