from pymatgen.io.vasp import Vasprun
from pymatgen.electronic_structure.plotter import DosPlotter
from pymatgen.core import Lattice, Structure,PeriodicSite




dosrun = Vasprun("./vasprun.xml", parse_dos=True)

cdos = dosrun.complete_dos
print(dosrun.efermi)
print(cdos.efermi)
dosplot = DosPlotter(sigma=0.05)
dosplot.add_dos("Total DOS", cdos)
      
plt = dosplot.get_plot()

plt.figure.savefig("dos.pdf")

exit()
