from pymatgen.io.vasp import Vasprun
from pymatgen.electronic_structure.plotter import DosPlotter
from pymatgen.core import Lattice, Structure,PeriodicSite


dosrun = Vasprun("./vasprun.xml", parse_dos=True)
cdos = dosrun.complete_dos
plotter = DosPlotter()

iatom=1
site=dosrun.final_structure[iatom-1]
spd_dos = cdos.get_site_spd_dos(site)

dos_dict = cdos.get_site_spd_dos(site)
for orbital, dos in dos_dict.items():
    if(str(orbital)=='d'):
       plotter.add_dos("Ni-"+str(orbital),dos)

plotter.show()
plotter.save_plot("ni_d.pdf")
exit()

