import numpy as np
import scipy as sp
import scipy.optimize as opt
import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt
import pylab
import os, time
import multiprocessing
import scipy.sparse.linalg as sparselin
import cmath
import matplotlib.tri as tri
import matplotlib.mlab as griddata
import matplotlib.colors as mcolors
import scipy.linalg as linalg
import argparse
import matplotlib.mlab as griddata
import matplotlib.transforms as mtransforms
import matplotlib.gridspec as gridspec
from   matplotlib import rc
from   matplotlib.animation import FFMpegWriter
from   mpl_toolkits.axes_grid1 import make_axes_locatable
from   pylab import *
from   scipy.signal import savgol_filter
from   scipy.interpolate import make_interp_spline
from   matplotlib import image as mpimg
from   mpl_toolkits.axes_grid1 import make_axes_locatable
from   PIL import Image
import os.path
#----------------------------- rc Parameters-----------------------------------
w= 3.375; h = 1.35; fs = 14; lw = 1.5; ax_lw = 0.5; tick_M = 1.5; tick_m = 0.8;
tex = 1; minor_x = 0; minor_y = 0; np_h=4; np_v=3; minor = 0; mks = 1;
mew=0.1; FontFamily="Times New Roman";
if minor: 
    minor_x = 1
    minor_y = 1
#------------------------------------------------------------------------------
# Tex
plt.rcParams['text.usetex'] = False
rcParams.update({'font.family': FontFamily})
# Fig
rcParams.update({'figure.figsize': [w*np_h,h*np_v]})
rcParams.update({'figure.dpi': 150}) 
rcParams.update({'legend.fontsize': fs})
# Axes
rcParams.update({'axes.labelsize' : fs})
rcParams.update({'axes.linewidth':  ax_lw})
# Ticks
rcParams.update({'xtick.labelsize': fs-2})
rcParams.update({'ytick.labelsize': fs-2}) 
rcParams.update({'xtick.direction': 'in'}) 
rcParams.update({'ytick.direction': 'in'}) 
rcParams.update({'xtick.major.width': ax_lw}) 
rcParams.update({'ytick.major.width': ax_lw}) 
rcParams.update({'xtick.major.pad': 3})
rcParams.update({'ytick.major.pad': 3})
rcParams.update({'xtick.major.size': tick_M})
rcParams.update({'ytick.major.size': tick_M})  
rcParams.update({'xtick.top': False}) 
rcParams.update({'xtick.labeltop': False}) 
rcParams.update({'xtick.bottom': True})  
rcParams.update({'xtick.labelbottom': True})
if minor_x:
    rcParams.update({'xtick.minor.visible':True})
    rcParams.update({'xtick.minor.size': tick_m}) 
    rcParams.update({'xtick.minor.width': ax_lw}) 
if minor_y:
    rcParams.update({'ytick.minor.visible':True})  
    rcParams.update({'ytick.minor.size': tick_m}) 
    rcParams.update({'ytick.minor.width': ax_lw}) 
# Lines
rcParams.update({'lines.markersize': mks})
rcParams.update({'lines.linewidth': lw})
rcParams.update({'lines.markeredgewidth': mew})
#------------------------------------------------------------------------------

#------------------------------- Plot Function---------------------------------
def PlotFun(ax, X, Y, NP, PCol, PLab, PLSty, XLab, YLab, Tit, TitFS, SetZ, SetminY, FSize, Legloc, LegFS):
    if NP>1:
        for iY in range(NP):
            ax.plot(X, Y[:,iY], label = PLab[iY], linestyle = PLSty, color = PCol[iY])    
    else:
        ax.plot(X, Y, label = PLab, linestyle = PLSty, color = PCol) 
    ax.set_title(Tit, fontsize=TitFS)
    ax.set_xlabel(XLab, fontsize=FSize)
    ax.set_ylabel(YLab, fontsize=FSize, labelpad=2)
    ax.set_xlim(min(X),max(X))
    if SetminY:
        ax.set_ylim(bottom=0.0, top=max(Y[:])*1.1)
    if len(PLab)!=0 and PLab[0]!='':
        ax.legend(loc=Legloc, framealpha=0.0, fontsize=LegFS)
    if SetZ:
        ax.axhline(0.0, lw=0.01, color='k')
#------------------------------------------------------------------------------
#------------------------------- Variables ------------------------------------
Orbitals  = ['s',  '$p_x$', '$p_y$', '$p_z$', '$d_{z^2}$', '$d_{x^2-y^2}$', '$d_{xy}$', '$d_{xz}$', '$d_{yz}$', '$f_{z^3}$', '$f_{xz^2}$', '$f_{yz^2}$', '$f_{zx^2}$', '$f_{xyz}$', '$f_{x^3-3xy^2}$', '$f_{3yx^2-y^3}$']
Orbital   = ['s1', 'p1', 'p2', 'p3', 'd1', 'd2', 'd3', 'd4', 'd5', 'f1', 'f2', 'f3', 'f4', 'f5', 'f6', 'f7']
#------------------------------------------------------------------------------

for F in os.listdir():
    if F.endswith(".in"):
        fname = F
f = open(fname,'r')
while True:
    line = f.readline()
    if "System.Name" in line:
        SysNam = str(line.split()[1])
    if "scf.SpinPolarization" in line:
        if str(line.split()[1]).lower()=='off':
            SP = 1
        else:
            SP = 2
        break
f.close()
EnL = -6
EnU = 8
        
#-----------------------------  Figure ----------------------------------------   
fig = plt.figure(figsize=(8,6),constrained_layout=False)
gs  = gridspec.GridSpec(nrows=1, ncols=1, figure=fig, left=0.17, bottom=0.1, right=0.95, top=0.95, wspace=0.2, hspace=0.2)
ax1 = fig.add_subplot(gs[0,0]); 


path = SysNam+'.DOS.Tetrahedron'
check_file = os.path.isfile(path)
if check_file:
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax1, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='DFTU:Spin-Up', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax1, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='DFTU:Spin-Down', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='Total', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax1, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='DFTU', PLSty ='-', XLab='energy (eV)', YLab='DOS', Tit='Total', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    ax1.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax1.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax1.set_ylabel('DOS')
    ax1.set_xlabel('Energy (eV)')
    ax1.set_xlim(EnL,EnU)

    path = '../OMX-NiO-DFT/'+SysNam+'.DOS.Tetrahedron'
    Dos = np.loadtxt(path); 
    if SP:
        PlotFun(ax=ax1, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='DFT:Spin-Up', PLSty ='dotted', XLab='energy (eV)', YLab='DOS', Tit='', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
        PlotFun(ax=ax1, X=Dos[:,0], Y=Dos[:,2], NP=1, PCol='r', PLab='DFT:Spin-Down', PLSty ='dotted', XLab='energy (eV)', YLab='DOS', Tit='Total', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    else:
        PlotFun(ax=ax1, X=Dos[:,0], Y=Dos[:,1], NP=1, PCol='b', PLab='DFT', PLSty ='dotted', XLab='energy (eV)', YLab='DOS', Tit='Total', TitFS=fs, SetZ=0, SetminY=0, FSize=fs, Legloc='best', LegFS=fs)
    ax1.axvline(0.0, lw=0.5, color='k', linestyle=':')
    ax1.axhline(0.0, lw=0.5, color='k', linestyle=':')
    ax1.set_ylabel('DOS')
    ax1.set_xlabel('Energy (eV)')
    ax1.set_xlim(EnL,EnU)
    
plt.savefig('DOSNiO.png', bbox_inches='tight', dpi=200)



